﻿var mySurveys = {
    context: $(".v-mySurveys"),
    datatable: null,
    treeview: null,
    selectedItems: null,
    getTableColumns: function () {
        var columns = [
            { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true, "Type": "numeric" },
            { "Name": "Name", "Title": resources.SurveyName, "Data": "Name", "Class": "itemName", "HideInSelector": true, "Width": "20%" },
            {
                "Name": "SurveyQuickActions", "Sortable": false, "Visible": true, "HideInSelector": true, "AdvancedFilter": false, "Title": "", "Class": "no-wrap", "Data": function (row) {
                    var content = "";

                    var fastIcons = $("<div />", { "class": "h-fastIcons fast-icons displayOnHover", "data-surveyid": row.Id });

                    if (row.CanViewQuestionnaire)
                        fastIcons.append($("<a/>", { "data-action": "edit", "title": resources.Edit, "href": "#" }).append(voxco.icons.getIcon("edit")));

                    if (row.CanViewDistribution)
                        fastIcons.append($("<a/>", { "data-action": "distribute", "title": resources.Distribute, "href": "#" }).append(voxco.icons.getIcon("distribute")));

                    if (row.CanViewSurveyStatus)
                        fastIcons.append($("<a/>", { "data-action": "analyze", "title": resources.Analyze, "href": "#" }).append(voxco.icons.getIcon("analyze")));
                    else if (row.IsOffline && row.CanViewOfflineActivity)
                        fastIcons.append($("<a/>", { "data-action": "offline", "title": resources.Analyze, "href": "#" }).append(voxco.icons.getIcon("analyze")));

                    if (row.CanAccessSentimentDashboard) {
                        fastIcons.append($("<a/>", { "data-action": "textAndSentimentAnalysis", "title": advancedAnalyticsResources.AdvancedAnalytics, "href": "#" }).append(voxco.icons.getIcon("text-and-sentiment-analysis")));
                    }

                    content = fastIcons.outerHTML();

                    return content;
                }
            },
            { "Name": "ModifiedOn", "Title": resources.Updated, "Data": "ModifiedOn", "Type": "datetime" },
            {
                "Name": "Status", "Title": resources.Status, "Class": "no-wrap", "Type": "enum", "EnumType": "SurveyStatus", "Data": function (row) {
                    var statusLabel = row["StatusEnum"];

                    if (statusLabel) {
                        if (row["EvaluatedStatus"] && statusLabel != row["EvaluatedStatusEnum"])
                            statusLabel += " (" + row["EvaluatedStatusEnum"] + ")";
                    }
                    else {
                        statusLabel = row["EvaluatedStatusEnum"];
                    }

                    return statusLabel || "";
                }
            },
            { "Name": "FolderName", "Title": resources.SurveyFolder, "Data": "FolderName", "Visible": false },
            { "Name": "Completed", "Title": resources.Completed, "Data": "Participation", "Type": "numeric" },
            { "Name": "TotalCases", "Title": resources.TotalCases, "Data": "TotalCases", "Visible": false, "Type": "numeric" },
            { "Name": "ToDo", "Title": resources.ToDo, "Data": "ToDo", "Visible": false, "Type": "numeric" },
            { "Name": "DropOuts", "Title": resources.DropOuts, "Data": "DropOuts", "Visible": false, "Type": "numeric" },
            { "Name": "DropRate", "Title": resources.DropRate, "Data": "DropRate", "Visible": false, "Type": "numeric", "Suffix": "%" },
            { "Name": "CompletionRate", "Title": resources.CompletionRate, "Data": "CompletionRate", "Visible": false, "Type": "numeric", "Suffix": "%" },
            { "Name": "UseS2", "Title": resources.UseS2, "Data": "UseS2", "Visible": false, "Type": "boolean", "ShowIcon": true }
        ];

        if (marketSightEnabled)
            columns.push({ "Name": "PublishInMarketSight", "Title": resources.VoxcoAnalytics, "Visible": false, "Type": "boolean", "ShowIcon": true });

        if (hasOfflinePermission)
            columns.push({ "Name": "IsCapi", "Title": resources.MobileOffline, "Data": "IsOffline", "Visible": false, "Type": "boolean", "ShowIcon": true });

        return columns;

    },
    initializeDataTable: function (folder) {
        this.datatable = $(".h-surveys-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetSurveys", "Home", "Survey"),
            ajaxParams: { "parentFolderId": folder ? folder.Id : 0 },
            columns: mySurveys.getTableColumns(),
            stateKey: "MySurveys",
            stateSaveSorting: false,
            toolBarItems: [
                { "Action": "move", "Label": resources.MoveTo, "DisplayCondition": function (data) { return data.CanBeModified; } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.CanBeDeleted; } }
            ],
            contextMenuItems: [
                {
                    "Label": resources.Edit,
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "Edit", controller: "Questionnaire" }, "Label": resources.Questionnaire, "DisplayCondition": function (data) { return data.CanViewQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "LookAndFeel" }, "Label": resources.LookAndFeel, "DisplayCondition": function (data) { return !data.UseS2 && data.CanViewQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "Theme" }, "Label": resources.LookAndFeel, "DisplayCondition": function (data) { return data.UseS2 && data.CanViewQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Import", controller: "ImportExport" }, "Label": resources.Import, "DisplayCondition": function (data) { return data.CanModifyQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Export", controller: "ImportExport" }, "Label": resources.Export, "DisplayCondition": function (data) { return data.CanViewQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "WordImport" }, "Label": resources.WordImport, "DisplayCondition": function (data) { return data.EnableWordImport && data.CanModifyQuestionnaire; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "Quotas" }, "Label": resources.Quotas, "DisplayCondition": function (data) { return data.CanViewQuotas; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "Simulation" }, "Label": resources.Simulate, "DisplayCondition": function (data) { return data.CanViewSimulation; } },
                        { "Action": "redirect", "Params": { action: "Index", controller: "ChangeLog" }, "Label": resources.ChangeLog, "DisplayCondition": function (data) { return data.CanViewChangeLog; } }
                    ]
                },
                {
                    "Label": resources.Distribute,
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "Index", controller: "Distribute" }, "Label": resources.Distributions, "DisplayCondition": function (data) { return data.CanViewDistribution; } },
                        { "Action": "redirect", "Params": { action: "ImportSample", controller: "Distribute" }, "Label": resources.ImportSample, "DisplayCondition": function (data) { return data.CanImportSample; } },
                        { "Action": "voxcoAudience", "Params": { action: "VoxcoAudience", controller: "Distribute" }, "Label": resources.VoxcoAudience, "DisplayCondition": function (data) { return data.EnableVoxcoAudience; } }
                    ]
                },
                {
                    "Label": resources.Analyze,
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "Index", controller: "Analyze" }, "Label": resources.Participation, "DisplayCondition": function (data) { return data.CanViewSurveyStatus; } },
                        { "Action": "redirect", "Params": { action: "Results", controller: "Analyze" }, "Label": resources.Results, "DisplayCondition": function (data) { return data.CanViewQuickResults; } },
                        { "Action": "redirect", "Params": { action: "Respondents", controller: "Analyze" }, "Label": resources.Responses, "DisplayCondition": function (data) { return data.CanViewRespondents; } },
                        { "Action": "redirect", "Params": { action: "ExportResponses", controller: "Analyze" }, "Label": resources.ExportResponses, "DisplayCondition": function (data) { return data.CanExtractResults; } },
                        { "Action": "redirect", "Params": { action: "OfflineActivity", controller: "Analyze" }, "Label": resources.OfflineActivity, "DisplayCondition": function (data) { return data.CanViewOfflineActivity && data.IsOffline; } },
                        { "Action": "analytics", "Label": resources.VoxcoAnalytics, "DisplayCondition": function (data) { return canAccessMarketSight && data.MarketSightDatasetId != null; } }
                    ]
                },
                {
                    "Label": advancedAnalyticsResources.AdvancedAnalytics, "DisplayCondition": function (data) { return data.CanAccessSentimentDashboard || data.CanAccessNpsDashboard || data.CanAccessTextHighlighterDashboard || data.CanAccessImageHeatMapDashboard; },
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "TextAndSentimentAnalysis", controller: "AdvancedAnalytics" }, "Label": advancedAnalyticsResources.TextAndSentimentAnalysis, "DisplayCondition": function (data) { return data.CanAccessSentimentDashboard; } },
                        { "Action": "redirect", "Params": { action: "NpsAnalyticsResults", controller: "NpsAnalytics" }, "Label": npsAnalyticsResources.NpsAnalyticsResults, "DisplayCondition": function (data) { return data.CanAccessNpsDashboard; } },
                        { "Action": "redirect", "Params": { action: "TextHighlighterResults", controller: "TextHighlighter" }, "Label": textHighlighterResources.TextHighlighterResults, "DisplayCondition": function (data) { return data.CanAccessTextHighlighterDashboard; } },
                        { "Action": "redirect", "Params": { action: "ImageHeatMapResults", controller: "ImageHeatMap" }, "Label": imageHeatMapResources.ImageHeatMapResults, "DisplayCondition": function (data) { return data.CanAccessImageHeatMapDashboard; } }
                    ]
                },
                {
                    "Label": resources.Translate, "DisplayCondition": function (data) { return data.CanViewTranslate; },
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "Questions", controller: "Translate" }, "Label": resources.Questions },
                        { "Action": "redirect", "Params": { action: "Messages", controller: "Translate" }, "Label": resources.Messages },
                        { "Action": "redirect", "Params": { action: "LookAndFeel", controller: "Translate" }, "Label": resources.LookAndFeel },
                        { "Action": "redirect", "Params": { action: "FindAndReplace", controller: "Translate" }, "Label": resources.FindAndReplace, "DisplayCondition": function (data) { return data.CanModifyTranslate; } }
                    ]
                },
                {
                    "Label": resources.Settings, "DisplayCondition": function (data) { return data.CanViewQuestionnaire; },
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "General", controller: "Settings" }, "Label": resources.General },
                        { "Action": "redirect", "Params": { action: "Questionnaire", controller: "Settings" }, "Label": resources.Questionnaire },
                        { "Action": "redirect", "Params": { action: "Access", controller: "Settings" }, "Label": resources.Access },
                        { "Action": "redirect", "Params": { action: "Session", controller: "Settings" }, "Label": resources.Session },
                        { "Action": "redirect", "Params": { action: "Termination", controller: "Settings" }, "Label": resources.Termination },
                        { "Action": "redirect", "Params": { action: "Mobile", controller: "Settings" }, "Label": resources.Mobile, "DisplayCondition": function (data) { return !data.UseS2; } },
                        { "Action": "redirect", "Params": { action: "Offline", controller: "Settings" }, "Label": resources.MobileOfflineSettings, "DisplayCondition": function (data) { return data.IsOffline; } }
                    ]
                },
                {
                    "Label": resources.MobileOffline, "DisplayCondition": function (data) { return data.IsOffline; },
                    "SubMenuItems": [
                        { "Action": "redirect", "Params": { action: "CaseAssignmentRules", controller: "Offline" }, "Label": resources.CaseAssignmentRules, "DisplayCondition": function (data) { return data.CanViewCaseAssignmentRules; } },
                        { "Action": "redirect", "Params": { action: "Quotas", controller: "Offline" }, "Label": resources.UserQuotas, "DisplayCondition": function (data) { return data.CanViewUserQuotas; } },
                        { "Action": "redirect", "Params": { action: "QualityControl", controller: "Offline" }, "Label": resources.QualityControl, "DisplayCondition": function (data) { return data.CanViewQualityControl; } }
                    ]
                },
                { "Divider": true },
                { "Action": "permissions", "Label": resources.EditPermissions, "DisplayCondition": function (data) { return canManagePermissions && data.CanBeModified; } },
                { "Divider": true },
                { "Action": "copy", "Label": resources.Copy, "DisplayCondition": function (data) { return data.CanBeModified; } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.CanBeDeleted; } },
                { "Action": "properties", "Label": resources.Properties },
                { "Divider": true },
                {
                    "Action": "reactivate", "Label": resources.ReactivateSurvey, "DisplayCondition": function (data) {
                        return data.CanBeStarted && data.Status == Enum.SurveyStatus.Stopped && data.EvaluatedStatus != Enum.SurveyStatus.NotOnline;
                    }
                },
                { "Action": "activate", "Label": resources.ActivateSurvey, "DisplayCondition": function (data) { return data.CanBeStarted && data.EvaluatedStatus == Enum.SurveyStatus.NotOnline; } },
                { "Action": "stop", "Label": resources.StopSurvey, "DisplayCondition": function (data) { return data.CanBeStarted && data.Status == Enum.SurveyStatus.Active; } },
                { "Divider": true },
                { "Action": "preview", "Label": resources.PreviewSurvey },
                { "Action": "test", "Label": resources.TestSurvey },
                { "Action": "take", "Label": resources.TakeSurvey },
                { "Action": "print", "Label": resources.Print }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                if (row) {
                    switch (action) {
                        case "redirect":
                            if (data.params.action == 'TextAndSentimentAnalysis') {
                                _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Open Text Analysis', 'Context Menu']);
                            }
                            mySurveys.surveyRedirect(data.params.controller, data.params.action, row.Id);
                            break;
                        case "analytics":
                            window.open(a4.getSurveyAction("Analytics", "Analyze", { surveyId: row.Id }));
                            break;
                        case "preview":
                            mode = (row.UseS2) ? 1 : 0;
                            _paq.push(['trackEvent', 'Survey-Action-PreviewSurvey', (row.UseS2 ? "S2" : "S1"), 'Context Menu']);
                            a4.previewSurvey(row.UseS2, row.SurveyToken);
                            break;
                        case "print":
                            modalDialog.showWindow(a4.getSurveyAction("Print", "Questionnaire", { surveyId: row.Id }), 750, 1000);
                            break;
                        case "test":
                            a4.testSurvey(row.UseS2, row.SurveyToken);
                            break;
                        case "take":
                            a4.takeSurvey(row.UseS2, row.SurveyToken);
                            break;
                        case "copy":
                            modalDialog.showWindow(a4.getSurveyAction("CopySurvey", "Home", { surveyId: row.Id }), 700, 750);
                            break;
                        case "delete":
                            mySurveys.deleteSurveys([row.Id], (row.Status == Enum.SurveyStatus.Active));
                            break;
                        case "properties":
                            mySurveys.displayProperties(false, row.Id);
                            break;
                        case "reactivate":
                            mySurveys.startSurvey(row.Id);
                            break;
                        case "activate":
                            mySurveys.startSurvey(row.Id, true);
                            break;
                        case "stop":
                            mySurveys.stopSurvey(row.Id);
                            break;
                        case "permissions":
                            modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: row.Id, name: row.Name, objectType: "Project" }), 800, 700);
                            break;
                        case "voxcoAudience":
                            _paq.push(['trackEvent', 'Survey-Distribute', 'Voxco Audience', 'Open Voxco Audience', 'Context Menu']);
                            window.open(a4.getSurveyAction("VoxcoAudience", "Distribute"), "_blank");
                            break;
                    }
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var items = _.map(rows, "Id");

                if (action == "delete") {
                    mySurveys.deleteSurveys(items);
                }
                else if (action == "move") {
                    mySurveys.moveSurveys(items);
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Stopped, "AjaxParams": { "status": parseInt(Enum.SurveyStatus.Stopped, 10) } },
                    { "Label": resources.Active, "AjaxParams": { "status": parseInt(Enum.SurveyStatus.Active, 10) } },
                    { "Label": resources.NotOnline, "AjaxParams": { "status": parseInt(Enum.SurveyStatus.NotOnline, 10) } },
                    { "Label": resources.Completed, "AjaxParams": { "status": parseInt(Enum.SurveyStatus.Completed, 10) } }
                ]
            },
            localizableTexts: { "All": resources.AllSurveys, "Search": resources.SearchSurveys }
        });
    },
    initializeTreeView: function () {
        var actionButtons = [];

        actionButtons.push({ Action: "moveto", Label: resources.MoveTo, Icon: "move-to", "DisplayCondition": function (data) { return data.ParentId > 0 && data.CanBeModified; } });

        if (canManagePermissions) {
            actionButtons.push({ Action: "permissions", Label: resources.EditPermissions, Icon: "lock" });
        }

        actionButtons.push({ Action: "delete", Label: resources.Delete, Icon: "remove", "DisplayCondition": function (data) { return data.ParentId > 0 && data.CanBeDeleted; } });
        actionButtons.push({ Action: "properties", Label: resources.Properties, Icon: "edit", "DisplayCondition": function (data) { return data.ParentId > 0 && data.CanBeModified; } });

        this.treeview = $(".h-surveyFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetSurveyFolders", "Home", "Survey"),
            saveState: true,
            stateKey: "MySurveys",
            draw: function (event, data) {
                var folder = data.selectedNode;

                if (mySurveys.datatable) {
                    mySurveys.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folder ? folder.Id : 0 });
                    mySurveys.datatable.a4datatable("refresh", true, true);
                }
                else {
                    mySurveys.initializeDataTable(folder);
                }

                if (folder)
                    $("#main-header .h-new-survey-menu", mySurveys.context).toggle(folder.CanBeModified);

                //Toggle treeview
                mySurveys.datatable.a4datatable("toggleToolBarItem", "move", data.count > 1);
                $(".v-tableContainer", mySurveys.context).toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);

                //a4.setResizablePanels($(".left-panel", mySurveys.context), $(".right-panel", mySurveys.context));
            },
            selectNode: function (event, data) {
                mySurveys.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": data.node.Id });
                mySurveys.datatable.a4datatable("refresh", true);
                $("#main-header .h-new-survey-menu", mySurveys.context).toggle(data.node.CanBeModified);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "moveto":
                        mySurveys.moveFolders([node.Id]);
                        break;
                    case "properties":
                        mySurveys.displayProperties(true, node.Id);
                        break;
                    case "delete":
                        mySurveys.deleteFolder(node.Id);
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: node.Id, name: node.Name, objectType: "Project" }), 800, 700);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchSurveyFolders }
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-create-new-survey", function () {
            var rootFolderId = mySurveys.getRootFolderId();
            modalDialog.showWindow(a4.getAction("CreateSurvey", "Home", "Survey", { FolderId: rootFolderId }), 700, 750);
        });

        $(".h-new-survey-menu").on("click", "li.h-new-survey", function () {
            var selectedFolderId = mySurveys.getSelectedFolderId();
            modalDialog.showWindow(a4.getAction("CreateSurvey", "Home", "Survey", { FolderId: selectedFolderId }), 700, 750);
        });

        $(".h-new-survey-menu").on("click", "li.h-new-folder", function () {
            var selectedFolderId = mySurveys.getSelectedFolderId();
            modalDialog.showWindow(a4.getAction("CreateFolder", "Home", "Survey", { ParentId: selectedFolderId }), 410, 700, { afterClose: mySurveys.refreshContent });
        });

        surveyMenu.onAfterRefresh = mySurveys.refreshContent;

        this.context.on("click", ".h-fastIcons a", function () {
            var surveyId = $(this).closest(".h-fastIcons").attr("data-surveyid");

            switch ($(this).attr("data-action")) {
                case "edit":
                    mySurveys.surveyRedirect("Questionnaire", "Edit", surveyId);
                    break;
                case "distribute":
                    mySurveys.surveyRedirect("Distribute", "Index", surveyId);
                    break;
                case "analyze":
                    mySurveys.surveyRedirect("Analyze", "Index", surveyId);
                    break;
                case "offline":
                    mySurveys.surveyRedirect("Analyze", "OfflineActivity", surveyId);
                    break;
                case "textAndSentimentAnalysis":
                    mySurveys.surveyRedirect("AdvancedAnalytics", "Index", surveyId);
                    break;
                case "npsAnalyticsResults":
                    mySurveys.surveyRedirect("NpsAnalytics", "Index", surveyId);
                    break;
                case "textHighlighterResults":
                    mySurveys.surveyRedirect("TextHighlighter", "Index", surveyId);
                    break;
                case "imageHeatMapResults":
                    mySurveys.surveyRedirect("ImageHeatMap", "Index", surveyId);
                    break;
            }
        });

        $(".h-recycle-bin").on("click", function () {
            modalDialog.showWindow(a4.getAction("SurveyRecycleBin", "Home", "Survey"), 700, 1200, { afterClose: mySurveys.refreshContent });
        });
    },
    deleteSurveys: function (surveyIds, decreaseActiveSurveyCount) {
        var resourceToRender = confirmDeleteSurveyResources;

        if ($("#RecybleBinEnabled", mySurveys.context).val().toUpperCase() === "TRUE") {
            resourceToRender = confirmRecycleBinSurveyResources;
        }

        modalDialog.showConfirmDialog(resourceToRender, function () {
            a4.callServerMethod(a4.getAction("DeleteSurveys", "Home", "Survey"), { surveyIds: surveyIds },
                function (result) {
                    surveyMenu.refresh();

                    if (decreaseActiveSurveyCount) {
                        var surveyCountContainer = $(".v-surveyCount");
                        var surveyCount = parseInt($("span", surveyCountContainer).html());
                        var newSurveyCount = surveyCount - 1;

                        surveyCountContainer.html("<span>" + newSurveyCount + "<span>&nbsp;" + (newSurveyCount > 1 ? resources.ActiveSurveys : resources.ActiveSurvey));
                    }
                });
        }, 250, 500, true, { "count": surveyIds.length });
    },
    deleteFolder: function (folderId) {
        var resourceToRender = confirmDeleteSurveyFolderResources;

        if ($("#RecybleBinEnabled", mySurveys.context).val().toUpperCase() === "TRUE") {
            resourceToRender = confirmRecycleBinSurveyFolderResources;
        }

        modalDialog.showConfirmDialog(resourceToRender, function () {
            a4.callServerMethod(a4.getAction("DeleteFolder", "Home", "Survey"), { folderId: folderId },
                function (result) {
                    surveyMenu.refresh();
                });
        }, 250, 500, true, { "count": 1 });
    },
    getRootFolderId: function () {
        return $("#RootFolderId", mySurveys.context).val();
    },
    getSelectedFolderId: function () {
        var selectedFolder = $(".h-surveyFolders", mySurveys.context).a4listview("getHighlightedNode");
        if (selectedFolder) {
            var selectedFolderId = selectedFolder.Id;
            if (selectedFolderId) {
                return selectedFolderId;
            }
        }
        return mySurveys.getRootFolderId();
    },
    moveFolders: function (items) {
        console.log(items);
        modalDialog.showWindow(a4.getAction("MoveToFolder", "Home", "Survey", { items: items, isFolder: true }), 300, 500);
    },
    moveSurveys: function (items) {
        console.log(items);
        modalDialog.showWindow(a4.getAction("MoveToFolder", "Home", "Survey", { items: items }), 300, 500);
    },
    moveTofolder: function (isFolder, folderId, items) {
        if (isFolder) {
            a4.callServerMethod(a4.getAction("MoveFolders", "Home", "Survey"), { destId: folderId, folderIds: items },
                function (result) {
                    mySurveys.refreshContent();
                });
        } else {
            a4.callServerMethod(a4.getAction("MoveSurveys", "Home", "Survey"), { destId: folderId, surveyIds: items },
                function (result) {
                    mySurveys.refreshContent();
                });
        }
    },
    displayProperties: function (isFolder, itemId) {
        if (isFolder) {
            modalDialog.showWindow(a4.getSurveyAction("FolderProperties", "Home", { id: itemId }), 550, 700, { afterClose: mySurveys.refreshContent });
        }
        else {
            modalDialog.showWindow(a4.getSurveyAction("SurveyProperties", "Home", { surveyId: itemId }), 550, 800, { afterClose: surveyMenu.refresh });
        }
    },
    refreshContent: function () {
        mySurveys.treeview.a4listview("refresh");
    },
    refreshAnchorLinkIdParam: function (el, surveyId) {
        var regex = /\/[0-9]*$/;
        var newAnchVal = el.attr("href").replace(regex, "");
        newAnchVal += "/" + surveyId;
        el.attr("href", newAnchVal);
    },
    surveyRedirect: function (controller, action, surveyId) {
        window.location = a4.getSurveyAction(action, controller, { surveyId: surveyId });
    },
    redirectTo: function (action) {
        window.location = action;
    },
    startSurvey: function (surveyId, haveToDeploy) {
        a4.callServerMethod(a4.getAction("StartSurvey", "Home", "Survey"), { surveyId: surveyId, haveToDeploy: haveToDeploy }, function (result) {
            surveyMenu.refresh();
            mySurveys.updateActiveSurveyCount(result.totalActiveSurvey)
        });
    },
    stopSurvey: function (surveyId) {
        a4.callServerMethod(a4.getAction("StopSurvey", "Home", "Survey"), { surveyId: surveyId }, function (result) {
            surveyMenu.refresh();
            mySurveys.updateActiveSurveyCount(result.totalActiveSurvey)
        });
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    },
    updateActiveSurveyCount: function (activeSurveyCount) {
        var surveyCountContainer = $(".v-surveyCount");
        surveyCountContainer.html("<span>" + activeSurveyCount + "<span>&nbsp;" + (activeSurveyCount > 1 ? resources.ActiveSurveys : resources.ActiveSurvey));
    }
}

$(document).ready(function () {
    if (mySurveys.context.length > 0) {
        mySurveys.initializeTreeView();
        mySurveys.bindEvents();
    }

    if (typeof hasExpirationNotification !== 'undefined' && hasExpirationNotification && (!sessionStorage.getItem('notificationClosed') || sessionStorage.getItem('notificationClosed') == 'false')) {
        $("#header-container").css("top", "40px");
        $("#main-header").css("top", "98px");
        $("#main").css("margin-top", "40px");
    }

    $("#license-expiration-bar-close").click(function () {
        sessionStorage.setItem('notificationClosed', 'true');
        $("#license-expiration-bar").hide();
        $("#header-container").css("top", "0px");
        $("#main-header").css("top", "58px");
        $("#main").css("margin-top", "0px");
    });
});